/*
 * Decompiled with CFR 0.152.
 */
package entities.creatures.enemies;

import core.states.GameState;
import entities.Entity;
import entities.creatures.EnemyCreatureEntity;
import entities.missiles.lux.LuxAbilityQEntity;
import entities.missiles.lux.LuxAbilityREntity;
import entities.missiles.lux.LuxAbilityWEntity;
import entities.missiles.lux.LuxShotEntity;
import java.util.ArrayList;
import java.util.Random;
import strategies.ai.LuxAi;
import util.Config;
import util.ResourceManager;

public final class LuxEntity
extends EnemyCreatureEntity {
    private long lastMoveSpeedChange = 0L;
    private Random random;
    private double passiveMultiplier;
    private LuxAbilityREntity lastR = null;

    public LuxEntity(GameState game, int x, int y) {
        super(game, "creatures/lux", x, y);
        this.entityIcon = ResourceManager.get().getSprite("icons/lux/creature");
        this.setHitpoints(Config.get(Config.luxHitpoints));
        this.setMoveSpeed(Config.get(Config.luxMoveSpeed));
        this.shotCooldown = Config.get(Config.luxShotCooldown);
        this.abilityQCooldown = Config.get(Config.luxAbilityQCooldown);
        this.abilityWCooldown = Config.get(Config.luxAbilityWCooldown);
        this.abilityRCooldown = Config.get(Config.luxAbilityRCooldown);
        this.ai = new LuxAi();
        this.ai.setEntity(this);
    }

    @Override
    protected void set() {
        super.set();
        this.ai = new LuxAi();
        this.random = new Random();
        this.lastR = null;
    }

    public LuxAbilityREntity getLastR() {
        return this.lastR;
    }

    public void resetLastR() {
        this.lastR = null;
    }

    public long getLastAbilityQTime() {
        return this.lastAbilityQTime;
    }

    @Override
    public void reset() {
        super.reset();
        this.dx = this.random.nextBoolean() ? this.moveSpeed : -this.moveSpeed;
    }

    @Override
    public void move(long delta) {
        if (!this.canMove()) {
            return;
        }
        this.lastMoveSpeedChange += delta;
        if (this.lastR != null) {
            this.dy = 0.0;
            this.dx = 0.0;
        } else if (this.lastMoveSpeedChange > 150L) {
            this.lastMoveSpeedChange = 0L;
            this.dx = this.dx > 0.0 ? Math.abs(this.random.nextDouble() * this.moveSpeed) : (this.dx < 0.0 ? -Math.abs(this.random.nextDouble() * this.moveSpeed) : (this.random.nextBoolean() ? Math.abs(this.random.nextDouble() * this.moveSpeed) : -Math.abs(this.random.nextDouble() * this.moveSpeed)));
            this.dy = this.dy > 0.0 ? Math.abs(this.random.nextDouble() * this.moveSpeed) : (this.dy < 0.0 ? -Math.abs(this.random.nextDouble() * this.moveSpeed) : (this.random.nextBoolean() ? Math.abs(this.random.nextDouble() * this.moveSpeed) : -Math.abs(this.random.nextDouble() * this.moveSpeed)));
        }
        super.move(delta);
    }

    @Override
    public void notifyDeath() {
        this.game.removeEntity(this.lastR);
        ArrayList<Entity> entities = this.game.getEntities();
        for (Entity entity : entities) {
            if (!(entity instanceof LuxAbilityWEntity)) continue;
            this.game.removeEntity(entity);
        }
        ResourceManager.get().stopSound("lux_abilityQ");
        ResourceManager.get().stopSound("lux_abilityQ2");
        ResourceManager.get().stopSound("lux_abilityW");
        ResourceManager.get().stopSound("lux_abilityW2");
        ResourceManager.get().stopSound("lux_abilityR");
        ResourceManager.get().stopSound("lux_abilityR2");
        ResourceManager.get().stopSound("lux_abilityR3");
        ResourceManager.get().playSound("lux_die");
        super.notifyDeath();
    }

    public boolean isUltiInitTimeOver() {
        return this.lastAbilityRTime != 0L && this.lastAbilityRTime + (long)Config.get(Config.luxAbilityRInitTime) < this.game.getTime();
    }

    public boolean isUltiBlastTimeOver() {
        return this.lastAbilityRTime != 0L && this.lastAbilityRTime + (long)Config.get(Config.luxAbilityRInitTime) + (long)Config.get(Config.luxAbilityRBlastTime) < this.game.getTime();
    }

    @Override
    protected void shot() {
        LuxShotEntity shot = new LuxShotEntity(this, this.game, (int)this.x + this.getW() / 2 - 24, (int)this.y + this.getH() / 2);
        this.game.addEntity(shot);
        ResourceManager.get().playSound("lux_shot");
    }

    @Override
    protected void abilityQ() {
        LuxAbilityQEntity shot = new LuxAbilityQEntity(this, this.game, (int)this.x + this.getW() / 2 - 24, (int)this.y + this.getH() / 2);
        this.game.addEntity(shot);
        ResourceManager.get().playSound(this.random.nextBoolean() ? "lux_abilityQ" : "lux_abilityQ2");
    }

    @Override
    protected void abilityW() {
        LuxAbilityWEntity shot = new LuxAbilityWEntity(this, this.game, (int)this.x + this.getW() / 2 - 24, (int)this.y + this.getH() / 2);
        this.game.addEntity(shot);
        ResourceManager.get().playSound(this.random.nextBoolean() ? "lux_abilityW" : "lux_abilityW2");
    }

    @Override
    protected void abilityE() {
    }

    @Override
    protected void abilityR() {
        LuxAbilityREntity shot = new LuxAbilityREntity(this, this.game, (int)this.x + this.getW() / 2 - 222, (int)this.y + this.getH() / 2);
        this.game.addEntity(shot);
        this.lastR = shot;
        switch (this.random.nextInt(3)) {
            case 0: {
                ResourceManager.get().playSound("lux_abilityR");
                break;
            }
            case 1: {
                ResourceManager.get().playSound("lux_abilityR2");
                break;
            }
            case 2: {
                ResourceManager.get().playSound("lux_abilityR3");
            }
        }
    }

    public void setPassiveMultiplier(double multiplier) {
        this.passiveMultiplier = multiplier;
    }

    public double getPassiveMultiplier() {
        return this.passiveMultiplier;
    }

    @Override
    public void draw() {
        super.draw();
        this.drawHealthbar(0, 0);
    }
}

